#!/bin/sh

set -e

failure() { echo "$1";  exit 1; }

fwinfo() {
	awk "/$1/ { print \$2 }" /etc/fw-info | tr -d '",'
}

if [ -f /etc/fw-info ]; then
	plat=$(fwinfo platform)
	inst_type=$(fwinfo install_type)

	if [ -n "$plat" ] && [ "$plat" != "aml" ]; then
		failure "Wrong firmware update file, target platform is aml"
	fi

	if [ -n "$inst_type" ] && [ "$inst_type" != "nand" ]; then
		failure "Wrong firmware update file, target installation type is nand"
	fi
fi

if [ -f fw.md5 ]; then
	echo "Verifying md5 checksums"
	md5sum -s -c fw.md5 > /dev/null 2>&1
fi

if [ ! -d /mnt/nvdata/anthillos ]; then
	echo "AnthillOS not installed!"
	exit 1
fi

if [ -f devicetree.dtb ]; then
	echo "Updating devicetree.dtb"
	cp -f devicetree.dtb /mnt/nvdata/anthillos > /dev/null 2>&1
fi

if [ -f vmlinux.bin ]; then
	echo "Updating vmlinux.bin"
	cp -f vmlinux.bin /mnt/nvdata/anthillos > /dev/null 2>&1
fi

if [ -e uramdisk.image.gz ]; then
	echo "Updating uramdisk.image.gz"
	cp -f uramdisk.image.gz /mnt/nvdata/anthillos > /dev/null 2>&1
fi

if ubiattach -d 5 -m 5; then
	mkdir -p /tmp/stock-config
	if mount -t ubifs ubi5_0 /tmp/stock-config; then
		if [ -e /tmp/stock-config/sn ]; then
			cp /tmp/stock-config/sn "/config/serial" || true
		fi
		umount /tmp/stock-config
	fi
	ubidetach -d 5
fi

sync