#!/bin/sh

set -e

failure() { echo "$1";  exit 1; }

fwinfo() {
	awk "/$1/ { print \$2 }" /etc/fw-info | tr -d '",'
}

if [ -f /etc/fw-info ]; then
	plat=$(fwinfo platform)
	inst_type=$(fwinfo install_type)

	if [ -n "$plat" ] && [ "$plat" != "bb" ]; then
		failure "Wrong firmware update file, target platform is bb"
	fi

	if [ -n "$inst_type" ] && [ "$inst_type" != "nand" ]; then
		failure "Wrong firmware update file, target installation type is nand"
	fi
fi

if [ -f fw.md5 ]; then
	echo "Verifying md5 checksums"
	md5sum -s -c fw.md5 > /dev/null 2>&1
fi

if [ ! -d /mnt/nvdata/anthillos ]; then
	echo "AnthillOS not installed!"
	exit 1
fi

if [ -f devicetree.dtb ]; then
	echo "Updating devicetree.dtb"
	cp -f devicetree.dtb /mnt/nvdata/anthillos > /dev/null 2>&1
fi

if [ -f uImage ]; then
	echo "Updating uImage"
	cp -f uImage /mnt/nvdata/anthillos > /dev/null 2>&1
fi

if [ -e uramdisk.image.gz ]; then
	echo "Updating uramdisk.image.gz"
	cp -f uramdisk.image.gz /mnt/nvdata/anthillos > /dev/null 2>&1
fi

mkdir -p /tmp/stock-config
if mount -t jffs2 /dev/mtdblock9 /tmp/stock-config/; then
	if [ -e /tmp/stock-config/sn ]; then
		cp /tmp/stock-config/sn "/config/serial" || true
	fi
	umount /tmp/stock-config
fi

sync